<?php
header('Content-Type: application/json');

if (!isset($_GET['pair'])) {
    echo json_encode(["error" => "Missing 'pair' parameter"]);
    exit;
}

$pair = strtoupper(trim($_GET['pair']));

// Google Sheet CSV URL
$csvUrl = 'https://docs.google.com/spreadsheets/d/1TV3b-WXa9U_ALpZQjOMgyJMdzn3qqcX0NRrq2byyRC0/pub?output=csv';

try {
    $csvData = file_get_contents($csvUrl);
    if ($csvData === false) {
        throw new Exception("Unable to fetch CSV");
    }

    $lines = explode("\n", $csvData);
    foreach ($lines as $index => $line) {
        if ($index === 0) continue; // skip header
        $columns = str_getcsv($line);
        if (count($columns) >= 2 && strtoupper(trim($columns[0])) === $pair) {
            $rate = floatval($columns[1]);
            echo json_encode(["pair" => $pair, "rate" => $rate]);
            exit;
        }
    }

    echo json_encode(["error" => "Currency pair not found"]);
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
}
