<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log');

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require __DIR__ . '/php/php-mailer/PHPMailer.php';
require __DIR__ . '/php/php-mailer/Exception.php';
require __DIR__ . '/php/php-mailer/SMTP.php';

$response = [];

try {
    $data = json_decode(file_get_contents('php://input'), true);
    if (!$data) throw new Exception("Invalid JSON input.");

    $to = $data['recipientEmail'] ?? null;
    $content = $data['content'] ?? null;
    $attachmentUrl = $data['attachmentPath'] ?? null; // This is a full URL, e.g. https://asp.nexus-int.com/uploads/...

    if (empty($to) || (empty($content) && empty($attachmentUrl))) {
        throw new Exception("Recipient email and content or attachment are required.");
    }

    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = 'mail.nexus-int.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'noreply@nexus-int.com';
    $mail->Password = '4po8jy)rU8ZP';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    $mail->setFrom('noreply@nexus-int.com', 'Nexus Quotations');
    $mail->addAddress($to);
    $mail->Subject = "Quotation from Nexus";
    $mail->isHTML(true);
    $mail->Body = $content ?: "Please find the attached quotation.";

    // ✅ Download remote PDF and attach it
    if (!empty($attachmentUrl)) {
        $pdfContent = @file_get_contents($attachmentUrl);
        if ($pdfContent === false) {
            throw new Exception("Unable to fetch attachment from: " . $attachmentUrl);
        }

        // Extract file name from URL
        $fileName = basename(parse_url($attachmentUrl, PHP_URL_PATH));
        $mail->addStringAttachment($pdfContent, $fileName, 'base64', 'application/pdf');
    }

    $mail->send();
    $response = ['status' => 'success', 'message' => "Email sent to $to"];
} catch (Exception $e) {
    $response = ['status' => 'error', 'message' => $e->getMessage()];
}

echo json_encode($response);
