<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Allow cross-origin requests
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Validate file upload
if (!isset($_FILES['file'])) {
    die(json_encode([
        "success" => false,
        "message" => "No file uploaded."
    ]));
}

$file = $_FILES['file'];
$folderPath = $_POST['folderPath'] ?? null;

if (!$folderPath) {
    die(json_encode([
        "success" => false,
        "message" => "Missing folder path."
    ]));
}

$ftpHost = "ftp.nexus-int.com";
$ftpUser = "nexusi6";
$ftpPass = "nexus.1512?";

$ftpConnection = ftp_connect($ftpHost);
if (!$ftpConnection || !ftp_login($ftpConnection, $ftpUser, $ftpPass)) {
    die(json_encode([
        "success" => false,
        "message" => "FTP connection failed."
    ]));
}

ftp_pasv($ftpConnection, true);

$ftpBaseFolder = "/DE/";
$ftpFolder = $ftpBaseFolder . $folderPath;

$directories = explode("/", $ftpFolder);
$currentPath = "";
foreach ($directories as $directory) {
    if (empty($directory)) continue;
    $currentPath .= "/" . $directory;
    if (!@ftp_chdir($ftpConnection, $currentPath)) {
        if (!ftp_mkdir($ftpConnection, $currentPath)) {
            ftp_close($ftpConnection);
            die(json_encode([
                "success" => false,
                "message" => "Failed to create directory: " . $currentPath
            ]));
        }
    }
}

$tempFilePath = $file['tmp_name'];
$ftpFilePath = $ftpFolder . "/" . basename($file['name']);

if (!ftp_put($ftpConnection, $ftpFilePath, $tempFilePath, FTP_BINARY)) {
    ftp_close($ftpConnection);
    die(json_encode([
        "success" => false,
        "message" => "Failed to upload file."
    ]));
}

ftp_close($ftpConnection);

echo json_encode([
    "success" => true,
    "message" => "File uploaded successfully.",
    "filePath" => "ftp://nexus-int.com" . $ftpFilePath
]);
?>
