<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Allow cross-origin requests
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Collect POST data
$fileData = $_POST['fileData'] ?? null;
$fileName = $_POST['fileName'] ?? null;
$folderPath = $_POST['folderPath'] ?? null;

if (!$fileData || !$fileName || !$folderPath) {
    die(json_encode([
        "success" => false,
        "message" => "Missing required parameters."
    ]));
}

// Decode base64 file data
$fileContent = base64_decode($fileData);
if ($fileContent === false) {
    die(json_encode([
        "success" => false,
        "message" => "Invalid base64 file data."
    ]));
}

// FTP credentials
$ftpHost = "ftp.nexus-int.com";
$ftpUser = "nexusi6";
$ftpPass = "nexus.1512?";

// Connect to FTP server
$ftpConnection = ftp_connect($ftpHost);
if (!$ftpConnection || !ftp_login($ftpConnection, $ftpUser, $ftpPass)) {
    die(json_encode([
        "success" => false,
        "message" => "FTP connection failed."
    ]));
}

ftp_pasv($ftpConnection, true);

// Generate full FTP path
$ftpBaseFolder = "/DE/";
$ftpFolder = $ftpBaseFolder . $folderPath;

$directories = explode("/", $ftpFolder);
$currentPath = "";
foreach ($directories as $directory) {
    if (empty($directory)) continue;
    $currentPath .= "/" . $directory;
    if (!@ftp_chdir($ftpConnection, $currentPath)) {
        if (!ftp_mkdir($ftpConnection, $currentPath)) {
            ftp_close($ftpConnection);
            die(json_encode([
                "success" => false,
                "message" => "Failed to create directory: " . $currentPath
            ]));
        }
    }
}

// Upload file
$tempFilePath = sys_get_temp_dir() . "/" . basename($fileName);
file_put_contents($tempFilePath, $fileContent);
$ftpFilePath = $ftpFolder . "/" . basename($fileName);

if (!ftp_put($ftpConnection, $ftpFilePath, $tempFilePath, FTP_BINARY)) {
    unlink($tempFilePath);
    ftp_close($ftpConnection);
    die(json_encode([
        "success" => false,
        "message" => "Failed to upload file."
    ]));
}

// Clean up and respond
unlink($tempFilePath);
ftp_close($ftpConnection);

echo json_encode([
    "success" => true,
    "message" => "File uploaded successfully.",
    "filePath" => "ftp://nexus-int.com" . $ftpFilePath
]);
