<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php-error.log');

// Handle CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

try {
    require __DIR__ . '/php/php-mailer/PHPMailer.php';
    require __DIR__ . '/php/php-mailer/Exception.php';
    require __DIR__ . '/php/php-mailer/SMTP.php';
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    exit;
}

$response = [];
try {
    // Read input JSON data
    $data = json_decode(file_get_contents('php://input'), true);
    if (!$data) {
        throw new Exception("Invalid JSON data.");
    }

    // Extract data
    $to = $data['recipientEmail'] ?? null;
    $content = $data['content'] ?? null;
    $from = "noreply@nexus-int.com";
    $fromName = "Nexus";
    $subject = "Agent Details";

    if (!$to || !$content) {
        throw new Exception("Recipient email and content are required.");
    }

    // Configure PHPMailer
    $mail = new PHPMailer(true);
    $mail->isSMTP();
    $mail->Host = 'mail.nexus-int.com'; // Replace with your SMTP host
    $mail->SMTPAuth = true;
    $mail->Username = 'noreply@nexus-int.com'; // Replace with your SMTP username
    $mail->Password = '4po8jy)rU8ZP'; // Replace with your SMTP password
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    $mail->setFrom($from, $fromName);
    $mail->addAddress($to);
    $mail->Subject = $subject;
    $mail->Body = $content;
    $mail->isHTML(true);

    // Send email
    $mail->send();

    // Success response
    $response['status'] = 'success';
    $response['message'] = 'Email sent successfully.';
} catch (Exception $e) {
    // Error response
    $response['status'] = 'error';
    $response['message'] = $e->getMessage();
}

// Return JSON response
echo json_encode($response);
