<?php
$ftpHost = "nexus-int.com";
$ftpUser = "nexusi6";
$ftpPass = "nexus.1512?";

// 1. Get paths array
$filePaths = isset($_POST['paths']) ? json_decode($_POST['paths']) : [];

if (!$filePaths || !is_array($filePaths)) {
    http_response_code(400);
    echo "No valid paths provided.";
    exit;
}

// 2. Connect to FTP
$conn = ftp_connect($ftpHost);
if (!$conn || !ftp_login($conn, $ftpUser, $ftpPass)) {
    http_response_code(500);
    echo "FTP login failed.";
    exit;
}
ftp_pasv($conn, true); // Enable passive mode

// 3. Create ZIP
$zipFile = tempnam(sys_get_temp_dir(), 'invoices') . '.zip';
$zip = new ZipArchive();
if (!$zip->open($zipFile, ZipArchive::CREATE)) {
    http_response_code(500);
    echo "Could not create ZIP archive.";
    exit;
}

$filesAdded = 0;

foreach ($filePaths as $path) {
   $remotePath = $path; // ✅ Use the full FTP path directly

    $tmpLocal = tempnam(sys_get_temp_dir(), 'ftpdl');

    $success = ftp_get($conn, $tmpLocal, $remotePath, FTP_BINARY);

    if ($success && filesize($tmpLocal) > 0) {
        $filename = basename($remotePath);
        $zip->addFile($tmpLocal, $filename);
        $filesAdded++;
    } else {
        error_log("❌ Failed or empty: $remotePath");
    }
}

ftp_close($conn);
$zip->close();

if ($filesAdded === 0) {
    unlink($zipFile);
    http_response_code(404);
    echo "No valid files were added to ZIP.";
    exit;
}

// 4. Send ZIP for download
$downloadName = isset($_POST['filename']) ? basename($_POST['filename']) : "All_Invoices.zip";
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $downloadName . '"');
header('Content-Length: ' . filesize($zipFile));
readfile($zipFile);
unlink($zipFile);
exit;

?>
